define(['AbstractHealthMoodService', 'HealthMoodService', 'HealthMoodServiceConstants', 'localResourceDirectoryService', 'CollectionCRUDService','connection_error_service','patient'], function() {
	'use strict';


	describe("The Abstract Health Service", function (){
		var service,
			focusServiceMock = jasmine.createSpy('focusService');

		beforeEach(function() {
			module('angularTemplateApp');

			module(function($provide){
				$provide.value('focusService', focusServiceMock);
			});

			inject(function(HealthMoodService) {
				service = HealthMoodService.instance('glucose');
			});
		});

		describe("when instantiated", function() {
			it("service should be defined correctly", function() {
				expect(service.config).toBeDefined();
				expect(service.config.dependency.service).toBeDefined();
				expect(service.config.collection.filter).toBeDefined();
				expect(service.config.collection.sortComparator).toBeDefined();
				expect(service.config.object.uidKey).toBeDefined();
				expect(service.config.object.responseTransform).toBeDefined();
				expect(service.config.object.requestTransform).toBeDefined();
				expect(service.createEmpty).toBeDefined();
			});
		});

		describe("methods", function() {
			it("should transform the date in the response", function() {
				var item = {
					recorded: null
				};
				expect(service.config.object.responseTransform(item)).toEqual(item);

				item.recorded = "12/12/2015 01:01:01";
				var transformedResponse = service.config.object.responseTransform(item);
				expect(transformedResponse.inputEntryDate).toEqual("12/12/2015");
				expect(transformedResponse.inputEntryTime).toEqual("01:01 AM");
			});

			it("should transform the date in the request", function() {
				var item = {
					recorded: null,
					inputEntryDate: null,
					inputEntryTime: null
				};
				expect(service.config.object.requestTransform(item)).toEqual(item);

				item.inputEntryDate = "12/12/2015";
				item.inputEntryTime = "01:01 AM";
				expect(service.config.object.requestTransform(item)).toEqual({
					recorded: "12/12/2015 01:01:00",
					inputEntryDate: "12/12/2015",
					inputEntryTime: "01:01 AM"
				});
			});

			it("should provide a filter", function() {
				var filters = null,
					listItem1 = { recorded: "01/12/2015 01:01:00" },
					listItem2 = { recorded: "06/12/2015 01:01:00" },
					listItem3 = { recorded: "12/12/2015 01:01:00" },
					list = [listItem1, listItem2, listItem3];
				expect(service.config.collection.filter(list, filters)).toEqual([listItem1, listItem2, listItem3]);

				filters = {
					startDate: "05/12/2015",
					endDate: "07/12/2015"
				};
				expect(service.config.collection.filter(list, filters)).toEqual([listItem2]);
			});

			it("should create an empty object", function() {
				expect(service.createEmpty()).toBeDefined();
				expect(service.createEmpty().notes).toEqual('');
				expect(service.createEmpty().name).toEqual('Glucose');
			});
		});
	});
});